function [Yss, Error] = SSFun(varargin)

%Steady state for MAPK
%Input is RasGTP (molecules/cell)

K = varargin{1};
S = varargin{2};
U = varargin{3};

y0 = [K.PKCtot 0 K.Raftot 0 0 K.P1tot 0 K.MEKtot 0 0 0 0 K.P2tot 0 0 K.ERKtot 0 0 0 0 K.P3tot 0 0 0 0 0 K.P4tot 0 U];
    

[T,Y] = ode15s(@ODEsFun,linspace(0,S.SS_Time,1000),y0,[],K);



if abs((Y(end,S.Ind)-Y(round(.9*end),S.Ind))/Y(end,S.Ind))>.001
    Error = 1;
else
    Error = 0;
end
Yss = Y(end,:);